/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.arcslogs;

import com.ibm.hwmca.base.arcslogs.ArcCopyDataException;
import com.ibm.hwmca.base.arcslogs.ArcMediaInUseException;
import com.ibm.hwmca.base.arcslogs.ArcMediaLabelException;
import com.ibm.hwmca.base.arcslogs.ArcMediaNotReadyException;
import com.ibm.hwmca.base.arcslogs.ArcMediaWriteProtectedException;
import com.ibm.hwmca.base.arcslogs.ArcNoSpaceException;
import com.ibm.hwmca.base.arcslogs.ArcRetrieveDataException;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WriteData {
    private static final String TRACE_MASKT = "XARCWRDT";
    private static final String TRACE_MASKF = "XARCWRDF";
    private static final String TRACE_MASKD = "XARCWRDD";
    private long mediaSpaceAvailable = 0L;
    private MediaServices mediaServices = null;
    private MediaDeviceIdentifier mediaDeviceIdentifier = null;
    private MediaDevice mediaDevice = null;
    private String mediaLabel = null;
    private File mediaMountPoint = null;
    private String stagingDirectory = null;
    private long totalSize = 0L;

    public void write() throws HException, ArcCopyDataException, ArcRetrieveDataException, ArcNoSpaceException, ArcMediaInUseException, ArcMediaNotReadyException, ArcMediaWriteProtectedException, ArcMediaLabelException {
        Trace.trace(TRACE_MASKT, "-> WriteDisk.write()");
        try {
            String dataDirectory = BaseFileControl.getFilePath("*.trm");
            this.stagingDirectory = dataDirectory + "arce4hmc";
            Trace.trace(TRACE_MASKD, "staging Dir = " + this.stagingDirectory);
            this.deleteAllFiles(this.stagingDirectory);
            new File(this.stagingDirectory).mkdir();
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "caught HException");
            Trace.trace(TRACE_MASKF, e);
            Trace.trace(TRACE_MASKT, "<- WriteDisk.write(), can not make staging directory");
            throw e;
        }
        try {
            this.getDataFromSource(this.stagingDirectory);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "caught exception getting data for hmc");
            Trace.trace(TRACE_MASKD, e);
        }
        Trace.trace(TRACE_MASKF, "totalSize = " + this.totalSize + ", mediaSpace = " + this.mediaSpaceAvailable);
        if (this.totalSize == 0L) {
            Trace.trace(TRACE_MASKF, "No files to write");
            new File(this.stagingDirectory).delete();
            throw new ArcRetrieveDataException("No files to write");
        }
        if (this.totalSize + 5000L > this.mediaSpaceAvailable) {
            this.deleteAllFiles(this.stagingDirectory);
            new File(this.stagingDirectory).delete();
            throw new ArcNoSpaceException("space available = " + this.mediaSpaceAvailable + ", needed " + this.totalSize);
        }
        try {
            File[] listOfFiles = new File(this.stagingDirectory).listFiles();
            int numberOfFiles = Array.getLength(listOfFiles);
            int ix = 0;
            while (ix < numberOfFiles) {
                String fileName = listOfFiles[ix].getName();
                String destName = this.mediaMountPoint + "/" + fileName;
                FileUtilities.copy(listOfFiles[ix], new File(destName));
                listOfFiles[ix].delete();
                ++ix;
            }
            try {
                this.mediaDevice.unlock();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "ignoring exception");
                Trace.trace(TRACE_MASKF, e);
            }
            try {
                Trace.trace(TRACE_MASKD, "sleeping after unlock ");
                Thread.sleep(3000L);
                new File(this.stagingDirectory).delete();
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "<-WriteDisk.write caught exception");
            Trace.trace(TRACE_MASKF, e);
            throw new ArcCopyDataException(e);
        }
        Trace.trace(TRACE_MASKT, "<- WriteDisk.write()");
    }

    private void getDataFromSource(String dir) throws ArcRetrieveDataException {
        Trace.trace(TRACE_MASKT, "-> WriteDisk.getDataFromSource()");
        String fileName = this.generateFileName(dir);
        try {
            Trace.trace(TRACE_MASKD, "local fileName = [" + fileName + "]");
            this.totalSize += this.retrieveFile(fileName);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "caught Exception from retrieveFile");
            Trace.trace(TRACE_MASKF, e);
            ArcRetrieveDataException retrieveException = new ArcRetrieveDataException(e);
            throw retrieveException;
        }
        Trace.trace(TRACE_MASKT, "<- WriteDisk.getDataFromSource()");
    }

    public void prepareMedia(int targetMedia) throws HException, ArcMediaInUseException, ArcMediaWriteProtectedException, ArcMediaLabelException, ArcMediaNotReadyException {
        Trace.trace(TRACE_MASKT, "-> WriteDisk.prepareMedia()");
        if (targetMedia != 1 && targetMedia != 3) {
            Trace.trace(TRACE_MASKT, "<- WriteDisk.write() invalid targetMedia [" + targetMedia + "]");
            throw new HException("invalid targetMedia [" + targetMedia + "]");
        }
        try {
            LocalizableText tsdName = new LocalizableText("ArcE4");
            this.mediaServices = MediaServices.getMediaServices();
            if (this.mediaServices == null) {
                Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() MediaDeviceException(mediaService = null)");
                throw new HException("mediaServices returned null");
            }
            Trace.trace(TRACE_MASKD, "mediaServices = [" + this.mediaServices + "]");
            Trace.trace(TRACE_MASKD, "targetMedia is " + targetMedia);
            this.mediaDeviceIdentifier = this.mediaServices.getPreferredDevice(targetMedia);
            if (this.mediaDeviceIdentifier == null) {
                Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() MediaDeviceException(no preffered device)");
                throw new HException("no preferred device for mediatype [" + targetMedia + "]");
            }
            this.mediaDevice = this.mediaServices.requestLock(tsdName, this.mediaDeviceIdentifier);
            if (!this.mediaDevice.isMounted()) {
                Trace.trace(TRACE_MASKD, "mounting media");
                this.mediaDevice.mountReadWrite();
            }
            if (this.mediaDevice.isReadOnly()) {
                Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() MediaDeviceException(readonly)");
                this.mediaDevice.unlock();
                throw new ArcMediaWriteProtectedException("Device is read only; needs to be writable");
            }
            this.mediaLabel = this.mediaDevice.getLabel();
            if (!(this.mediaLabel == null || targetMedia == 1 || this.mediaLabel.equals("ACTSECLG") || this.mediaLabel.equals("") || this.mediaLabel.equals("Volume"))) {
                Trace.trace(TRACE_MASKF, "label = [" + this.mediaLabel + "]");
                Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() MediaDeviceException(label wrong)");
                this.mediaDevice.unlock();
                throw new ArcMediaLabelException("wrong label [" + this.mediaLabel + "]");
            }
            this.mediaSpaceAvailable = this.mediaDevice.getAvailableSpace();
            Trace.trace(TRACE_MASKF, "mediaSpace = " + this.mediaSpaceAvailable);
            this.mediaMountPoint = this.mediaDevice.getMountPoint();
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() no media");
            throw new ArcMediaNotReadyException(e);
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() write protected");
            throw new ArcMediaWriteProtectedException(e);
        }
        catch (InvalidFileSystemException e) {
            Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() invalid file system");
            throw new ArcMediaLabelException(e);
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() locked");
            throw new ArcMediaInUseException(e);
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia() mediadeviceexception");
            throw new HException(e);
        }
        Trace.trace(TRACE_MASKT, "<- WriteDisk.prepareMedia()");
    }

    public long retrieveFile(String fqFileName) throws ArcRetrieveDataException {
        Trace.trace(TRACE_MASKT, "-> WriteDisk.retrieveFile()");
        Trace.trace(TRACE_MASKD, "fqFileName =" + fqFileName);
        long fileSize = 0L;
        String hmcFileName = "";
        try {
            String dataDirectory = BaseFileControl.getFilePath("iqyye4.log");
            hmcFileName = dataDirectory + "iqyye4.log";
            FileUtilities.copy(hmcFileName, fqFileName);
            fileSize = new File(fqFileName).length();
            Trace.trace(TRACE_MASKF, "fileSize = " + fileSize);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "caught Exception on get for " + hmcFileName);
            Trace.trace(TRACE_MASKF, e);
            new File(fqFileName).delete();
            try {
                this.mediaDevice.unlock();
            }
            catch (Exception ex) {
                Trace.trace(TRACE_MASKF, "caught unlock() exception");
                Trace.trace(TRACE_MASKF, ex);
            }
            throw new ArcRetrieveDataException(e);
        }
        Trace.trace(TRACE_MASKT, "<- WriteDisk.retrieveFile()");
        return fileSize;
    }

    public void deleteAllFiles(String dir) {
        block5: {
            Trace.trace(TRACE_MASKT, "-> deleteAllFiles(" + dir + ")");
            try {
                File[] listOfFiles = new File(dir).listFiles();
                if (listOfFiles == null) break block5;
                int numberOfFiles = Array.getLength(listOfFiles);
                int ix = 0;
                while (ix < numberOfFiles) {
                    try {
                        String fileName = listOfFiles[ix].getName();
                        Trace.trace(TRACE_MASKF, "deleting file [" + dir + "/" + fileName + "]");
                        File file = new File(dir + "/" + fileName);
                        file.delete();
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "caught Exception ");
                        Trace.trace(TRACE_MASKF, e);
                    }
                    ++ix;
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "caught Exception ");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- deleteAllFiles(" + dir + ")");
    }

    private String generateFileName(String dir) {
        Trace.trace(TRACE_MASKT, "-> generateFileName()");
        String objectName = "";
        objectName = HMC.getHMC().getUIInfo().getTitle();
        if (objectName == null) {
            objectName = "thisHMC";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date currentDate = new Date();
        String dateTime = dateFormat.format(currentDate);
        String fqFileName = dir + "/" + objectName + dateTime + ".log";
        Trace.trace(TRACE_MASKT, "<- generateFileName(), fqFileName =" + fqFileName);
        return fqFileName;
    }
}

